from codeable_detectors.basic_detectors import AtLeastOneFileMatchesDetector
from codeable_detectors.evidences import FailedEvidence, ComponentEvidence
from codeable_detectors.js.jsDetectors import detect_js_import
from codeable_detectors.utils import update_keyword_args


class JSPrometheusMonitor(AtLeastOneFileMatchesDetector):
    def __init__(self):
        super().__init__()
        self.file_endings = ["js"]
        self.importName = "prom-client"

    def detect_in_context(self, ctx, **kwargs):
        options = update_keyword_args({'guessed_name': None}, kwargs)
        name = options["guessed_name"] + " Prometheus Monitor"

        import_matches = detect_js_import(ctx, self.importName)
        if not import_matches:
            return FailedEvidence("JS '" + self.importName + "' import not found")

        return ComponentEvidence(import_matches).set_properties(
            detector_name=name, detector_component_types="monitoringComponent",
            detector_link_types="inMemoryConnector",
            detector_technology_types="prometheus", kwargs=kwargs)
